#pragma once

#include "Library3_h.h"

namespace ABI
{
	namespace Library3
	{
		class Game : public RuntimeClass<IGame>
		{
			InspectableClass(L"Library3.Game", BaseTrust)

		public:
			Game();
			STDMETHOD(get_RegisterUser)(HSTRING* value);
			STDMETHOD(put_RegisterUser)(HSTRING value);
			STDMETHOD(StartGame)(HSTRING value);
			STDMETHOD(add_UserLogged)(IGameEventHandler* handler, EventRegistrationToken* token);
			STDMETHOD(remove_UserLogged)(EventRegistrationToken token);

		private:
			void Notify(HSTRING value);

		private:
			std::wstring name;		
			bool m_observed;
			EventSource<IGameEventHandler> m_events;
		};

		ActivatableClass(Game);
	}
}
